/**
* \file: Factory.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Utility
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include "Factory.h"

namespace adit { namespace utility
{

Factory::Factory()
{
    debugLevel = nullptr;
    errorLevel = nullptr;
}

void Factory::setLogger(LogFn inDebugLevel, LogFn inErrorLevel)
{
    debugLevel = inDebugLevel;
    errorLevel = inErrorLevel;
}

Factory::Impl* Factory::_getImpl(const std::string& name, const std::type_info& inTypeInfo,
        const std::type_info& inConstructorInfo)
{
    if (name.empty())
        return nullptr;

    auto it = factoryMap.begin();

    it = factoryMap.find(name);
    if (it == factoryMap.end())
    {
        logMsg(errorLevel, "factory: %s is not registered", name.c_str());
        return nullptr;
    }
    else if (it->second.typeInfo != inTypeInfo)
    {
        logMsg(errorLevel, "factory: %s is registered as %s, not as %s", name.c_str(),
                it->second.typeInfo.name(), inTypeInfo.name());
        return nullptr;
    }
    else if (it->second.constructorInfo != inConstructorInfo)
    {
        logMsg(errorLevel, "factory: %s constructor is registered %s, not as %s", name.c_str(),
                        it->second.constructorInfo.name(), inConstructorInfo.name());
        return nullptr;
    }
    // else: proceed
    return &it->second;
}

bool Factory::_register(const std::string& inName, const std::type_info& inTypeInfo,
        const std::type_info& inConstructorInfo, CreateImplFn inCreator)
{
    if (inCreator == nullptr || inName.empty())
        return false;

    auto it = factoryMap.find(inName);
    if (it != factoryMap.end())
    {
        // name already registered, cancel
        return false;
    }

    Impl impl = { inTypeInfo, inConstructorInfo, inCreator };
    logMsg(debugLevel, "factory: register %s of type %s", inName.c_str(), inTypeInfo.name());
    factoryMap.insert(std::pair<std::string, Impl>(inName, impl));
    return true;
}

void Factory::logMsg(LogFn inLogLevel, const char* msg, ...)
{
    if (inLogLevel == nullptr)
        return;

    char buf[1024];
    va_list args;
    va_start(args, msg);
    vsnprintf(buf, sizeof(buf), msg, args);
    va_end(args);

    inLogLevel(buf);
}

} } // namespace adit { namespace utility
